const SOUND_FILES = {
  ping: "sounds/ping.wav",
  chime: "sounds/chime.wav",
  bell: "sounds/bell.wav",
};

async function playSoundFile(soundChoice) {
  const file = SOUND_FILES[soundChoice] || SOUND_FILES.ping;
  const url = chrome.runtime.getURL(file);
  const audio = new Audio(url);
  audio.volume = 0.4;
  try {
    await audio.play();
  } catch (_) {}
}

chrome.runtime.onMessage.addListener((msg, _sender, sendResponse) => {
  if (msg && msg.type === "PLAY_SOUND") {
    const choice = msg.options?.soundChoice;
    playSoundFile(choice).then(
      () => sendResponse({ ok: true }),
      () => sendResponse({ ok: false })
    );
    return true;
  }
  return false;
});
